//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "VisasmConfig.h"
#include "inifiles.hpp"
#include "Unit1.h"
#include "Unit3.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TVisAsmConfigForm *VisAsmConfigForm;
//---------------------------------------------------------------------------
__fastcall TVisAsmConfigForm::TVisAsmConfigForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TVisAsmConfigForm::OKButtonClick(TObject *Sender)
{
  TIniFile* IniFile = new TIniFile( ChangeFileExt(ParamStr(0),".INI")); 
  try
  {
	// update the global dir variables.
    Form1->DirInfo.BasePath			= BasePathEdit->Text;
    Form1->DirInfo.ProjectPath 		= BaseProjPathEdit->Text;
    Form1->DirInfo.ModulePath 		= BaseModulePathEdit->Text;

    Form1->DirInfo.APIPath			= BaseModulePathEdit->Text + "\API\\";
    Form1->DirInfo.ASMPath          = BaseModulePathEdit->Text + "\ASM\\";
    Form1->DirInfo.CPath			= BaseModulePathEdit->Text + "\C\\";
    Form1->DirInfo.LibraryPath		= BaseModulePathEdit->Text + "\Library\\";
    Form1->DirInfo.IntPath			= BaseModulePathEdit->Text + "\Int\\";
    Form1->DirInfo.OpcodePath 		= BaseModulePathEdit->Text + "\Opcodes\\" ;

    // Save path settings to the ini file
    IniFile->WriteString("Main", "Install", BasePathEdit->Text);
    IniFile->WriteString("Main", "Projects", BaseProjPathEdit->Text);
    IniFile->WriteString("Main", "Modules", BaseModulePathEdit->Text);

    IniFile->WriteString("Defaults", "API", Form1->DirInfo.APIPath);
    IniFile->WriteString("Defaults", "ASM", Form1->DirInfo.ASMPath );
    IniFile->WriteString("Defaults", "C",   Form1->DirInfo.CPath );
    IniFile->WriteString("Defaults", "Library", Form1->DirInfo.LibraryPath );
    IniFile->WriteString("Defaults", "Int", Form1->DirInfo.IntPath );
    IniFile->WriteString("Defaults", "Opcodes", Form1->DirInfo.OpcodePath );

    // All settings done. Now use the new settings

    Form3->LoadInsertables();

  }
  catch( ... )
  {
    IniFile->Free();
    Close();
  }
IniFile->Free();
Close();
}


//---------------------------------------------------------------------------
void __fastcall TVisAsmConfigForm::CancelButtonClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TVisAsmConfigForm::ToolsButtonClick(TObject *Sender)
{
  Form1->Tools_ConfigureToolsClick(this);
}
//---------------------------------------------------------------------------
void __fastcall TVisAsmConfigForm::CompilerButtonClick(TObject *Sender)
{
  Form1->Options_ConfigureAssemblerClick(this);
}
//---------------------------------------------------------------------------
void __fastcall TVisAsmConfigForm::FormCreate(TObject *Sender)
{
  TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
  try
  {
 	BasePathEdit->Text = IniFile->ReadString("Main", "Install", "");
 	BaseProjPathEdit->Text = IniFile->ReadString("Main", "Projects", "");
    BaseModulePathEdit->Text = IniFile->ReadString("Main", "Modules", "");

    if (BasePathEdit->Text == "")
    {
      Form1->DirInfo.BasePath =  ExtractFilePath(Application->ExeName);
      Form1->DirInfo.ProjectPath = Form1->DirInfo.BasePath + "\Projects\\";

    }
    if (BaseModulePathEdit->Text == "")
    {
      // check that the assembler is chosen, else default to tasm
      if (Form1->AssemblerInfo.Assembler == "") Form1->AssemblerInfo.Assembler = "TASM";
      if (Form1->AssemblerInfo.CPU == "") Form1->AssemblerInfo.CPU = "386";
      if (Form1->AssemblerInfo.Platform == "") Form1->AssemblerInfo.Platform = "Win32";
      Form1->DirInfo.ModulePath = Form1->DirInfo.BasePath + "\Modules\\" ;

    }
    //set up tools
  if (Form1->Tools.Calc =="")Form1->Tools.Calc =  Form1->DirInfo.BasePath + "\Tools\\Calc\\Calc.exe";
  if (Form1->Tools.Text =="")Form1->Tools.Text =  Form1->DirInfo.BasePath + "\Tools\\Text\\Vatt.exe";
  if (Form1->Tools.Res =="")Form1->Tools.Res =   Form1->DirInfo.BasePath + "\Tools\\Resedit\\Resedit.exe";
  if (Form1->Tools.Dump =="")Form1->Tools.Dump =  Form1->DirInfo.BasePath + "\Tools\\Dump\\Dumpbin.exe";
  if (Form1->Tools.Debug =="")Form1->Tools.Debug  =  Form1->DirInfo.BasePath + "\Tools\\Debug\\nwdebug.exe";
  if (Form1->Tools.Dis =="")Form1->Tools.Dis =  Form1->DirInfo.BasePath + "\Tools\\Dis\\Dis.com";
  if (Form1->Tools.Hex =="")Form1->Tools.Hex =  Form1->DirInfo.BasePath + "\Tools\\Hex\\Hexedit.exe";
  if (Form1->Tools.Browse =="")Form1->Tools.Browse = Form1->DirInfo.BasePath + "\Tools\\Browser\\Vapb.exe";

    // all set up. Now update with the editboxes
    BaseProjPathEdit->Text = Form1->DirInfo.ProjectPath;
    BasePathEdit->Text = Form1->DirInfo.BasePath;
    BaseModulePathEdit->Text = Form1->DirInfo.ModulePath ;

  }
  catch( ... )
  {
    IniFile->Free();
    throw;
  }
  IniFile->Free();
}

